% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rBPS}
\alias{rBPS}
\title{Reconstructed Binary Pathology Slide}
\format{
\code{rBPS} is a 314-by-224 binary matrix where each entry
corresponds to a tissue or region in the H&E image. In our case the ones and
zeros indicate an empty region or tumor tissue, respectively.
}
\source{
Original H&E slide available at
\url{https://biometry.nci.nih.gov/cdas/nlst/}.
}
\usage{
data(rBPS)
}
\description{
This reconstructed binary image was first represented as a three-class image,
prepared using a tumor recognition system (ConvPath) developed by the
Quantitative Biomedical Research Center. The original whole-slide image
comes from a lung cancer patient in the Lung Screening Study (LSS)
subcomponent of NLST. Specifically, this is an image from an H&E-stained
slide that was obtained as part of a pathology specimen collection.
}
\references{
ConvPath: A software tool for lung adenocarcinoma digital
pathological image analysis aided by a convolutional neural network. (2019)
EBioMedicine.
}
\keyword{dataset}
