% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blogs.R
\name{get_blog_blocks}
\alias{get_blog_blocks}
\title{Retrieve Blogs Blocks}
\usage{
get_blog_blocks(blog, limit = 20, offset = 0, app_credentials = NULL)
}
\arguments{
\item{blog}{name of the blog}

\item{limit}{number of blocks to retrieve (1-20)}

\item{offset}{block number to start at (default 0)}

\item{app_credentials}{a named list containing the consumer key and consumer secret. If NULL, attempts to load from an env variable}
}
\value{
tibble of blocked blogs
}
\description{
Get the blogs that the requested blog is currently blocking. The requesting user must be an admin of the blog to retrieve this list.  Note that this endpoint is rate limited to 60 requests per minute.
}
\examples{
\dontrun{
# replace "your-blog-name" with your Tumblr username
get_blog_blocks(blog = "your-blog-name")
}
}
