% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimHS_maxI.R
\name{trimHS_maxI}
\alias{trimHS_maxI}
\title{Trims the H-S association matrix maximizing the incongruence}
\usage{
trimHS_maxI(N, HS, n, check.unique = TRUE, strat = "sequential", cl = 1)
}
\arguments{
\item{N}{Number of runs.}

\item{HS}{Host-Symbiont association matrix.}

\item{n}{Number of associations.}

\item{check.unique}{if \code{TRUE} discards duplicated trimmed matrices. This
alternative is recommended if \code{n} is small, because the
probability of obtaining the same trimmed matrix in different runs
increases as \code{n} decreases.}

\item{strat}{Flag indicating whether execution is to be  \code{"sequential"}
or \code{"parallel"}. Default is \code{"sequential"},
resolves \R expressions sequentially in the current \R
process. If \code{"parallel"} resolves \R expressions in parallel in
separate \R sessions running in the background.}

\item{cl}{Number of cluster to be used for parallel computing.
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}
returns the number of clusters available.
Default is \code{cl = 1} resulting in \code{"sequential"} execution.}
}
\value{
A list of the N trimmed matrices.
}
\description{
For N runs, it randomly chooses \code{n} associations and trims the H-S
association matrix to include them, allowing both single and multiple
associations.
}
\examples{
\donttest{
data(nuc_cp)
N = 10  #for the example, we recommend 1e+4 value
n = 15
TNC <- trimHS_maxI(N, np_matrix, n, check.unique = TRUE)
}

}
