% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dlaplace}
\alias{dlaplace}
\title{Returns density from Laplace Distribution}
\usage{
dlaplace(x, m = 0, a = 1)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter.}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{dlaplace} returns the density at point x for the
Laplace distribution with parameters \eqn{a} and \eqn{m}.
}
\details{
The Laplace distribution is a distribution controlled
by two parameters, with formula:
\deqn{f(x;a,m) = \frac{1}{2a} e^{- \left| \frac{x-m}{a} \right| }}
where \eqn{a} is a scale parameter, and \eqn{m} is a location parameter.
}
