\name{UPdateEQLOC}
\alias{UPdateEQLOC}
\title{Update an Earthquake location
}
\description{Update an Earthquake location following
a relocation.
}
\usage{
UPdateEQLOC(PF, sol, vel, stas = NULL)
}
\arguments{
  \item{PF}{Pickfile List
}
  \item{sol}{solution vector (lat, lon, z, t0)
}
 \item{vel}{ 1D velocity model
}
  \item{stas}{station list (name, lat, lon, z)
}
}
\details{After re-picking or changing the model or the
station corrections, update the event location in
the pickfile.

}
\value{Pickfile List
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{EQXYresid, NLSlocate,PFoutput
}
\examples{

data(GH, package='RSEIS')

g1 = GH$pickfile
data(VELMOD1D, package='RSEIS')

vel= VELMOD1D

 w1 = which(!is.na(g1$STAS$lat))
         sec = g1$STAS$sec[w1]

         N = length(sec)
         Ldat =    list(
           name = g1$STAS$name[w1],
           sec = g1$STAS$sec[w1],
           phase = g1$STAS$phase[w1],
           lat=g1$STAS$lat[w1],
           lon = g1$STAS$lon[w1],
           z = g1$STAS$z[w1],
           err= g1$STAS$err[w1],
           yr = rep(g1$LOC$yr , times=N),
           jd = rep(g1$LOC$jd, times=N),
           mo = rep(g1$LOC$mo, times=N),
           dom = rep(g1$LOC$dom, times=N),
           hr =rep( g1$LOC$hr, times=N),
           mi = rep(g1$LOC$mi, times=N) )

  wstart = which.min(Ldat$sec)
  EQ = list(lat=Ldat$lat[wstart], lon=Ldat$lon[wstart], z=6, t=Ldat$sec[wstart] )
      

 AQ = Vlocate(Ldat,EQ,vel, 
      distwt = 10,
      lambdareg =100 ,
      REG = TRUE,
      WTS = TRUE,
      STOPPING = TRUE,
      tolx =   0.01,
      toly = 0.01 ,
      tolz = 0.05, maxITER = c(7,5,7,4) , RESMAX = c(0.1, 0.1),  PLOT=FALSE)

sol = c(AQ$EQ$lat, AQ$EQ$lon, AQ$EQ$z, AQ$EQ$t)

upf = UPdateEQLOC(g1, sol  , vel, stas=g1$STAS)

}
\keyword{misc}
