% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_heatmap.R
\name{create_heatmap}
\alias{create_heatmap}
\title{create_heatmap}
\usage{
create_heatmap(
  df,
  aes_x = NULL,
  aes_y = NULL,
  aes_label = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  aes_size = NULL,
  aes_width = NULL,
  aes_height = NULL,
  tile_sz = 1.1,
  tile_color = "white",
  tile_fill = "white",
  label_sz = 6,
  label_color = "black",
  label_fontface = "plain",
  label_alpha = 1,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  x_major_date_breaks = waiver(),
  x_minor_date_breaks = waiver(),
  x_date_labels = waiver(),
  x_log10 = FALSE,
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  y_log10 = FALSE,
  x_y_decimals = NULL,
  x_y_scientific = NULL,
  axis_text_size = 11,
  panel_color = "white",
  panel_border_color = "black",
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.5,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame from which the heatmap is plotted.}

\item{aes_x}{The x axis variable name from 'df'. This is a required discrete numeric,
Date/POSIXct variable.}

\item{aes_y}{The y axis variable name from 'df'. This is a required discrete numeric.}

\item{aes_label}{Sets the variable name from 'df' as the source for the tile's text.}

\item{aes_color}{The discrete/continuous variable name from 'df' for the aesthetic mapping for color.}

\item{aes_fill}{The discrete/continuous variable name from 'df' for the aesthetic mapping for fill.}

\item{aes_size}{The variable name from 'df' for the aesthetic mapping for size.}

\item{aes_width}{The variable name from 'df' for the aesthetic mapping for width.}

\item{aes_height}{The variable name from 'df' for the aesthetic mapping for height.}

\item{tile_sz}{A numeric that sets the tile's size width attribute in millimeters.}

\item{tile_color}{A numeric that sets the tile's attribute border color.}

\item{tile_fill}{A string that sets the fill color attribute for the tile.}

\item{label_sz}{A numeric that sets the size of the label.}

\item{label_color}{A string that sets the label's color.}

\item{label_fontface}{A string that sets the label's font face. Acceptable values are "plain", "bold",
"italic", "bold.italic".}

\item{label_alpha}{A numeric that sets the label's alpha value.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{x_limits}{Depending on the class of 'aes_x', a numeric/Date/POSIXct 2 element vector that sets the minimum
and maximum for the x axis. Use NA to refer to the existing minimum and maximum.}

\item{x_major_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact major tic locations along the x axis.}

\item{x_minor_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact minor tic locations along the x axis.}

\item{x_labels}{A character vector with the same length as 'x_major_breaks', that labels the major tics.}

\item{x_major_date_breaks}{If the class of 'aes_x' is Date/POSIXct, a string containing the number and date unit
for major breaks. Examples: "1 year", "4 sec", "3 month", "2 week".}

\item{x_minor_date_breaks}{If the class of 'aes_x' is Date/POSIXct, a string containing the number and date unit
for minor breaks.}

\item{x_date_labels}{If the class of 'aes_x' is Date/POSIXct, a string containing the format codes, the strftime
format, for the date.
Examples: \code{\%Y-\%m}, \code{\%Y/\%b/\%d}, \code{\%H-\%M-\%S}}

\item{x_log10}{A logical which if \code{TRUE} will use a log10 scale for the x axis.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and  maximum for the y axis.
Use \code{NA} to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{y_log10}{A logical which if \code{TRUE} will use a log10 scale for the y axis.}

\item{x_y_decimals}{A two element numeric vector that set the number of decimals for the x and y tic labels.}

\item{x_y_scientific}{A two element logical vector that if TRUE uses scientific notation for the x and y tic labels.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function returns a ggplot2 x/y plot of a pair of discrete variables. Instead of a point, a
  rectangle/cell/tile is located for each x/y value with the cell itself being colored or sized depending on the value
  of a third associated discrete or continuous variable. Function wraps ggplot2 geom_tile to produce a heatmap that shows
  magnitude as an array of cells in two dimensions.
}
\examples{
library(ggplot2)
library(data.table)
library(RplotterPkg)

RplotterPkg::create_heatmap(
  df = RplotterPkg::spinrates,
  aes_x = "velocity",
  aes_y = "spinrate",
  aes_fill = "swing_miss",
  aes_label = "swing_miss",
  label_fontface = "bold",
  title = "Likelihood of swinging and missing on a fastball",
  x_title = "Velocity",
  y_title = "Spinrate",
  label_sz = 5,
  rot_y_tic_label = TRUE
) +
 ggplot2::scale_fill_gradientn(
   colors = RColorBrewer::brewer.pal(n = 9, name = "YlOrRd"),
   n.breaks = 8
 ) +
 ggplot2::guides(
   fill = ggplot2::guide_colorbar(
     ticks.colour = "black"
   )
 )

}
