% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2d.R
\name{Arrow.pcs}
\alias{Arrow.pcs}
\title{Add arrows in Polar Coordinate System}
\usage{
Arrow.pcs(theta, r1 = 0, r2 = 1e+06, o1 = c(0, 0), o2 = o1,
  ab1 = 1, ab2 = ab1, ...)
}
\arguments{
\item{theta}{Angle in polar coordinate system}

\item{r1, r2}{Radius of start and end points of the arrow.}

\item{o1, o2}{Origin}

\item{ab1, ab2}{Semi-major over semi-minor. ab=1 for a Ring.}

\item{...}{More options for graphics::arrows function.}
}
\description{
Add arrows in Polar Coordinate System
}
\examples{

x1=PCS2CCS(a=10, ab=1.5)
c1 = ab2c(a=10, ab=1.5)
plot(x1, type='n', xlim=c(-10,10), ylim=c(-10,10), asp=1)
abline(h=0, v=0, asp=1, lty=2)
graphics::lines(x1, col=2);
points(c1, 0, col=2) # focus
Arrow.pcs(theta = 1:12 * 30, r1=0, r2=10, ab1=1.5, length=.1, col=2, o1 = c(c1,0), o2=c(0,0))

}
