% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{robyn_response}
\alias{robyn_response}
\title{Response and Saturation Curves}
\usage{
robyn_response(
  InputCollect = NULL,
  OutputCollect = NULL,
  json_file = NULL,
  select_build = NULL,
  select_model = NULL,
  metric_name = NULL,
  metric_value = NULL,
  date_range = NULL,
  dt_hyppar = NULL,
  dt_coef = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{OutputCollect}{List. Containing all model result.
Required when \code{robyn_object} is not provided.}

\item{json_file}{Character. JSON file to import previously exported inputs or
recreate a model. To generate this file, use \code{robyn_write()}.
If you didn't export your data in the json file as "raw_data",
\code{dt_input} must be provided; \code{dt_holidays} input is optional.}

\item{select_build}{Integer. Default to the latest model build. \code{select_build = 0}
selects the initial model. \code{select_build = 1} selects the first refresh model.}

\item{select_model}{Character. A model \code{SolID}. When \code{robyn_object}
is provided, \code{select_model} defaults to the already selected \code{SolID}. When
\code{robyn_object} is not provided, \code{select_model} must be provided with
\code{InputCollect} and \code{OutputCollect}, and must be one of
\code{OutputCollect$allSolutions}.}

\item{metric_name}{A character. Selected media variable for the response.
Must be one value from paid_media_spends, paid_media_vars or organic_vars}

\item{metric_value}{Numeric. Desired metric value to return a response for.}

\item{date_range}{Character. Date(s) to apply adstocked transformations and pick mean spends
per channel. Set one of: "all", "last", or "last_n" (where
n is the last N dates available), date (i.e. "2022-03-27"), or date range
(i.e. \code{c("2022-01-01", "2022-12-31")}). Default to "all".}

\item{dt_hyppar}{A data.frame. When \code{json_file} is not provided, use
\code{dt_hyppar = OutputCollect$resultHypParam}. It must be provided along
\code{select_model}, \code{dt_coef} and \code{InputCollect}.}

\item{dt_coef}{A data.frame. When \code{json_file} is not provided, use
\code{dt_coef = OutputCollect$xDecompAgg}. It must be provided along
\code{select_model}, \code{dt_hyppar} and \code{InputCollect}.}

\item{quiet}{Boolean. Keep messages off?}

\item{...}{Additional parameters passed to \code{robyn_outputs()}.}
}
\value{
List. Response value and plot. Class: \code{robyn_response}.
}
\description{
\code{robyn_response()} returns the response for a given
spend level of a given \code{paid_media_vars} from a selected model
result and selected model build (initial model, refresh model, etc.).
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect objects
## Recreate original saturation curve
Response <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "facebook_S"
)
Response$plot

## Or you can call a JSON file directly (a bit slower)
# Response <- robyn_response(
#   json_file = "your_json_path.json",
#   dt_input = dt_simulated_weekly,
#   dt_holidays = dt_prophet_holidays,
#   metric_name = "facebook_S"
# )

## Get the "next 100 dollar" marginal response on Spend1
Spend1 <- 20000
Response1 <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "facebook_S",
  metric_value = Spend1, # total budget for date_range
  date_range = "last_1" # last two periods
)
Response1$plot

Spend2 <- Spend1 + 100
Response2 <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "facebook_S",
  metric_value = Spend2,
  date_range = "last_1"
)
# ROAS for the 100$ from Spend1 level
(Response2$response_total - Response1$response_total) / (Spend2 - Spend1)

## Get response from for a given budget and date_range
Spend3 <- 100000
Response3 <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "facebook_S",
  metric_value = Spend3, # total budget for date_range
  date_range = "last_5" # last 5 periods
)
Response3$plot

## Example of getting paid media exposure response curves
imps <- 10000000
response_imps <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "facebook_I",
  metric_value = imps
)
response_imps$response_total / imps * 1000
response_imps$plot

## Example of getting organic media exposure response curves
sendings <- 30000
response_sending <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  metric_name = "newsletter",
  metric_value = sendings
)
# response per 1000 sendings
response_sending$response_total / sendings * 1000
response_sending$plot
}
}
