% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC_curve.R
\name{ROC_curve}
\alias{ROC_curve}
\title{ROC curve}
\usage{
ROC_curve(actual, predicted, d = c(0.01, 0.05, 0.1, 0.5))
}
\arguments{
\item{actual}{A vector of actual values (1/0 or TRUE/FALSE)}

\item{predicted}{A vector of predicted probabilities (numeric values in \eqn{[0,1]})}

\item{d}{A vector of length 4}
}
\value{
ROC curve.
}
\description{
Plot ROC curve together with recall / 1-precision curve.
}
\details{
Instead of a precision-recall curve, a recall / 1-precision curve is plotted
in the same coordinate system as the ROC curve.

Grey circles show the corresponding MCC optimal points;
black symbols show points optimal with respect to the robust MCC for different values of d.
}
\examples{
actual <- rf.data[, 1]
predicted <- rf.data[, 2]
ROC_curve(actual, predicted, d=c(0.01,0.02,0.1,0.5))

}
\references{
Holzmann, H., Klar, B. (2024). Robust performance metrics for imbalanced classification problems.
arXiv:2404.07661. \href{https://arxiv.org/abs/2404.07661}{LINK}
}
