% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-mh.R
\name{robincar_mh}
\alias{robincar_mh}
\title{Estimate Mantel-Haenszel Risk Difference}
\usage{
robincar_mh(
  df,
  treat_col,
  response_col,
  strata_cols,
  estimand = "ATE",
  ci_type = "mGR"
)
}
\arguments{
\item{df}{A data.frame with the required columns}

\item{treat_col}{Name of column in df with treatment variable. Must be binary}

\item{response_col}{Name of the column in df with response variable}

\item{strata_cols}{Names of columns in df with strata variables}

\item{estimand}{A character string specifying the estimand. One of "MH" or "ATE" (default). See Details}

\item{ci_type}{A character string specifying the type of confidence interval. One of "GR", "mGR" (default), "Sato"}
}
\description{
This function estimates Mantel-Haenszel risk difference and average treatment effect.
}
\details{
The estimand of interest can be either Mantel-Haenszel risk difference or Average Treatment Effect (ATE). 
The latter is the default option of `estimand`. When `estimand="ATE"`, `ci_type` is limited to the modified Greenland variance estimator (mGR).
 Otherwise, Greenland's variance estimator (GR) and Sato's variance estimator are optional.
}
\examples{
df <- RobinCar:::data_sim
df$y_bin = ifelse(df$y>2.5, 1, 0)
robincar_mh(df = df[df$A!=2,],
            treat_col = "A",
            response_col = "y_bin",
            strata_cols = c("z1", "z2"),
            estimand = "MH",
            ci_type = "mGR")

}
