% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots_sim_est.R
\name{plot.mp}
\alias{plot.mp}
\title{Plot Gaussian Haar-based multifractional processes with their
theoretical and estimated Hurst functions and local fractal dimension}
\usage{
\method{plot}{mp}(
  x,
  H = NULL,
  H_Est = TRUE,
  H_Smooth_Est = TRUE,
  LFD_Est = TRUE,
  LFD_Smooth_Est = TRUE,
  N = 100,
  Q = 2,
  L = 2,
  ...
)
}
\arguments{
\item{x}{Return from \code{\link{GHBMP}}. To get reliable results for simulated trajectories, it is recommended
to use at least 500 time points.}

\item{H}{Theoretical Hurst function. Optional: If provided, the theoretical Hurst function is plotted.}

\item{H_Est}{Logical: If \code{TRUE}, the Hurst function estimated by using \code{\link{Hurst}} is plotted.}

\item{H_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimated Hurst function is plotted.
The estimated Hurst function is smoothed using the loess method.}

\item{LFD_Est}{Logical: If \code{TRUE}, the local fractal dimension estimates are plotted.}

\item{LFD_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimates of local fractal dimension is plotted.
Smoothed using the loess method.}

\item{N}{Argument used for the estimation of Hurst functions and LFD. Number of sub-intervals on which the estimation is performed on. Default is set to 100 sub-intervals.}

\item{Q}{Argument used for the estimation of Hurst functions and LFD. Fixed integer greater than or equal to 2. Default is set to 2.}

\item{L}{Argument used for the estimation of Hurst functions and LFD. Fixed integer greater than or equal to 2. Default is set to 2.}

\item{...}{Other arguments.}
}
\value{
A ggplot object which is used to plot the multifractional process with theoretical, raw and smoothed estimates of Hurst function
and raw and smoothed estimates of local fractal dimension.
}
\description{
Creates a plot of the Gaussian Haar-based multifractional process
simulated by using \code{\link{GHBMP}} with theoretical Hurst function (if provided),
Hurst function estimated using \code{\link{Hurst}}, the smoothed estimated
Hurst function and local fractal dimension estimated using \code{\link{LFD}}
and smoothed estimates of local fractal dimension.
}
\examples{
\donttest{
#Simulation of the multifractional process and estimation of the Hurst function
T <- seq(0, 1, by = (1/2)^10)
H <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
X <- GHBMP(T, H)

#Plot of process, theoretical Hurst function, estimated and smoothed Hurst and LFD estimates
plot(X, H = H)

#Plot of process, estimated and smoothed Hurst and LFD estimates
plot(X)
}
}
\seealso{
\code{\link{GHBMP}}, \code{\link{Hurst}}, \code{\link{LFD}}
}
