% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanEstimation.R
\name{meanEstimation}
\alias{meanEstimation}
\title{Estimation of mean returns}
\usage{
meanEstimation(rets, control = list())
}
\arguments{
\item{rets}{a \eqn{(T \times N)}{(T x N)} matrix of past returns.}

\item{control}{control parameters (see *Details*).}
}
\value{
A \eqn{(N \times 1)}{(N x 1)} vector of expected returns.
}
\description{
Function which is used to compute the estimation of the mean returns.
}
\details{
The argument \code{control} is a list that can supply any of the following
components:
\itemize{ 
\item \code{type} method used to estimate the mean returns,
among \code{'naive'}, \code{'ewma'}, \code{'bs'} and \code{'mart'} where:

\code{'naive'} is used to compute the arithmetic mean of the returns.

\code{'ewma'} is used to compute the exponential weighted moving average
mean of the returns. The data must be sorted from the oldest to the latest. See RiskMetrics (1996).

\code{'bs'} is used to compute the Bayes-Stein estimation. See Jorion (1986).

\code{'mart'} is used to compute the Martinelli (2008) implied returns.

Default: \code{type = 'naive'}.

\item \code{lambda} decay parameter. Default: \code{lambda = 0.94}.
}
}
\examples{
# Load returns of assets or portfolios
data("Industry_10")
rets = Industry_10

# Naive estimation of the mean
meanEstimation(rets)

# Naive estimation of the mean
meanEstimation(rets, control = list(type = 'naive'))

# Ewma estimation of the mean with default lambda = 0.94
meanEstimation(rets, control = list(type = 'ewma'))

# Ewma estimation of the mean with lambda = 0.9
meanEstimation(rets, control = list(type = 'ewma', lambda = 0.9))

# Martinelli's estimation of the mean
meanEstimation(rets, control = list(type = 'mart'))

# Bayes-Stein's estimation of the mean
meanEstimation(rets, control = list(type = 'bs'))
}
\references{
Jorion, P. (1986).  
Bayes-Stein estimation for portfolio analysis. 
\emph{Journal of Finance and Quantitative Analysis} \bold{21}(3), pp.279-292. 

Martellini, L. (2008).  
Towards the design of better equity benchmarks.
\emph{Journal of Portfolio Management} \bold{34}(4), Summer,pp.34-41. 

RiskMetrics (1996)
\emph{RiskMetrics Technical Document}.
J. P. Morgan/Reuters.
}
\author{
David Ardia, Kris Boudt and Jean-Philippe Gagnon Fleury.
}
\keyword{htest}
