% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{plot_score}
\alias{plot_score}
\title{Plot Spatial Scores for a Specific Model and Metric}
\usage{
plot_score(object, which_score, which_model, ...)
}
\arguments{
\item{object}{A list containing test sets and model scores. The structure should include
`object$test_set` (list of sf objects) and `object$model[[which_model]]$score[[which_score]]`.}

\item{which_score}{A string specifying the score to visualize. Must match a score computed in the model.}

\item{which_model}{A string specifying the model whose scores to visualize.}

\item{...}{Additional arguments to customize ggplot, such as `scale_color_gradient` or `scale_color_manual`.}
}
\value{
A ggplot object visualizing the spatial distribution of the specified score.
}
\description{
This function visualizes spatial scores for a specified model and metric.
It combines test set data, handles duplicate locations by averaging scores,
and creates a customizable map using ggplot2.
}
