% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{plot_AnPIT}
\alias{plot_AnPIT}
\title{Plot Calibration Curves (AnPIT / PIT) from Spatial Cross-Validation}
\usage{
plot_AnPIT(
  object,
  mode = "average",
  test_set = NULL,
  model_name = NULL,
  combine_panels = FALSE
)
}
\arguments{
\item{object}{A \code{RiskMap.spatial.cv} object.}

\item{mode}{One of \code{"average"} (average curve across test sets),
\code{"single"} (a specific test set),
or \code{"all"} (every test set separately).}

\item{test_set}{Integer; required when \code{mode = "single"}.}

\item{model_name}{Optional character string; if supplied,
only that model is plotted.}

\item{combine_panels}{Logical; when \code{mode = "average"}, draw
all models in a single panel (\code{TRUE})
or one panel per model (\code{FALSE}, default).}
}
\value{
A \pkg{ggplot2} object (single plot) or a \pkg{ggpubr} grid.
}
\description{
Produce calibration plots from a \code{RiskMap.spatial.cv} object returned by
\code{\link{assess_pp}}.
* For Binomial or Poisson models the function visualises the
  \emph{Aggregated normalised Probability Integral Transform} (AnPIT)
  curves stored in \code{$AnPIT}.
* For Gaussian models it detects the list \code{$PIT} and instead plots
  the empirical \emph{Probability Integral Transform} curve
  (ECDF of PIT values) on the same \eqn{u}-grid.

A 45° dashed red line indicates perfect calibration.
}
