% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{convex_hull_sf}
\alias{convex_hull_sf}
\title{Convex Hull of an sf Object}
\usage{
convex_hull_sf(sf_object)
}
\arguments{
\item{sf_object}{An `sf` data frame object containing geometries.}
}
\value{
An `sf` object representing the convex hull of the input geometries.
}
\description{
Computes the convex hull of an `sf` object, returning the boundaries of the smallest polygon that can enclose all geometries in the input.
}
\details{
The convex hull is the smallest convex polygon that encloses all points in the input `sf` object. This function computes the convex hull by first uniting all geometries in the input using `st_union()`, and then applying `st_convex_hull()` to obtain the polygonal boundary. The result is returned as an `sf` object containing the convex hull geometry.
}
\examples{
library(sf)

# Create example sf object
points <- st_sfc(st_point(c(0,0)), st_point(c(1,1)), st_point(c(2,2)), st_point(c(0,2)))
sf_points <- st_sf(geometry = points)

# Calculate the convex hull
convex_hull_result <- convex_hull_sf(sf_points)

# Plot the result
plot(sf_points, col = 'blue', pch = 19)
plot(convex_hull_result, add = TRUE, border = 'red')
}
\seealso{
\code{\link[sf]{st_convex_hull}}, \code{\link[sf]{st_union}}
}
