% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_utils.R
\name{fs_used_vars_to_df}
\alias{fs_used_vars_to_df}
\title{extract the usage of the variables by a fuzzy system}
\usage{
fs_used_vars_to_df(fuzzy_system_desc)
}
\arguments{
\item{fuzzy_system_desc}{a fuzzy system description as a named list}
}
\value{
a one-row data frame, in columns the input and output variables, with TRUE iff the variable is used.
}
\description{
extract the usage of the variables by a fuzzy system
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
df <- mtcars[c("mpg", "hp", "wt", "qsec")]
fit <- fit(model, qsec ~ ., df, seed = 456, max_generations = 10, progress = FALSE)

print(fs_rules_to_df(fit$fuzzy_system))
}
\seealso{
Other fit_utils: 
\code{\link{fit_to_df}()},
\code{\link{fs_rules_to_df}()}
}
\concept{fit_utils}
