% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold.R
\name{pivot.approx}
\alias{pivot.approx}
\title{Computes the pivot \eqn{s_2} (approximate pivot)}
\usage{
pivot.approx(X)
}
\arguments{
\item{X}{nxd matrix (n observations, d dimensions)}
}
\value{
the approximate pivot
}
\description{
Computes the pivot \eqn{s_2} (approximate pivot)
}
\examples{
library(MASS)
mu = c(0,0)
Sigma = matrix(c(1,0.5,1,0.5), ncol = 2)
X = mvrnorm(n = 5000, mu = mu, Sigma = Sigma)
Phi = pivot.approx(X)

}
