% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCommentReplies.R
\name{getCommentReplies}
\alias{getCommentReplies}
\title{Extract replies to comments on page post}
\usage{
getCommentReplies(comment_id, token, n = 500, replies = TRUE,
  likes = FALSE, n.likes = n, n.replies = n, api = NULL)
}
\arguments{
\item{comment_id}{A comment ID}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{n}{numeric, maximum number of replies and likes to return.}

\item{replies}{logical, default is \code{TRUE}, which will return data frame
with replies to the post.}

\item{likes}{logical, default is \code{TRUE}, which will return data frame
with likes for the post.}

\item{n.likes}{numeric, maximum number of likes to return. Default is \code{n}.}

\item{n.replies}{numeric, maximum number of replies to return. Default is 
\code{n}.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
\code{getCommentReplies} retrieves the list of comments replying to 
an individual comment on a post by a public Facebook page.
}
\details{
\code{getCommentReplies} returns a list with three components: \code{comment}, 
\code{replies}, and \code{likes}. First, \code{comment} contains information
about the original comment: author, creation date, id, counts of likes and comments,
etc. Second, \code{replies} is a data frame with information about the replies
to the comment (author, message, creation time, id). Finally, \code{likes} is 
data frame that contains names and Facebook IDs of all the users that liked the comment.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about Facebook's Facebook Page
 load("fb_oauth")
 fb_page <- getPage(page="facebook", token=fb_oauth)
## Getting information and likes/comments about most recent post
 post <- getPost(post=fb_page$id[1], n=2000, token=fb_oauth)
## Downloading list of replies to first comment
 replies <- getCommentReplies(comment_id=post$comments$id[1], token=fb_oauth)
}

}
\author{
Yan Turgeon
}
\seealso{
\code{\link{getPage}}, \code{\link{getPost}}
}

