% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Leer_Datos.R
\name{Agregado_Prov_MIR}
\alias{Agregado_Prov_MIR}
\title{Download. Reading of aggregate data at the provincial level obtained from the MIR (Spanish Ministry of Home Office)}
\usage{
Agregado_Prov_MIR(Ano, Mes, Tipo, Ruta, Borrar = TRUE)
}
\arguments{
\item{Ano}{The election year in four-digit format (YYYY). Can be numeric or text.}

\item{Mes}{The election month. It has to be of character format. For example "06", corresponding to June.}

\item{Tipo}{The type of elections to which the data to be downloaded correspond: Congress (you must pass to the function the word "Congreso") or European (you must pass to the function the word "Europeas").}

\item{Ruta}{It is the local path from your computer where the zip files from the Spanish Ministry of Home Office (MIR) will be dowloaded.}

\item{Borrar}{It is a Boolean variable that indicates whether or not the downloaded files are deleted after creating the data.frame in R.}
}
\value{
Object of type 'tbl_df' with the data at provincial level.
}
\description{
This function is used to download the data in Excel format at the
provincial level and upload a data.frame with that information into R. Note: The
returned fields are all of character format, so if you need to perform
operations, you will have to convert the required fields to numeric.
}
\examples{

c<-Agregado_Prov_MIR(2019,"05",Tipo = "Europeas","F:/")


}
