library(testthat)
library(RealSurvSim)

#data("liang_recon", package = "RealSurvSim")
dat <- dats$Liang

# Test 1: data_simul_Estim function for all distributions
distributions <- c("inverse_gamma", "exp")
for (dist in distributions) {
  test_that(paste("Test 1:", dist, "distribution - simulates correct number of values"), {
    n_test <- 100
    simulated_data <- data_simul_Estim(orig_vals =dat$V1, n = n_test, distrib = dist)
    expect_length(simulated_data, n_test)
    expect_type(simulated_data, "double")
  })
}

# Test 2: data_simul_Estim handles default distribution (exp)
test_that("Test 2: data_simul_Estim handles default distribution (exp)", {
  n_test <- 100
  simulated_data <- data_simul_Estim(orig_vals = dat$V1, n = n_test)
  expect_length(simulated_data, n_test)
  expect_type(simulated_data, "double")
})

# Test 3: Error handling - non-numeric original values
test_that("Test 3: Error handling - non-numeric original values", {
  expect_error(data_simul_Estim(orig_vals = "non-numeric", n = 100, distrib = "exp"), "orig_vals must be a numeric vector.")
})

# Test 4: Error handling - empty original values
test_that("Test 4: Error handling - empty original values", {
  expect_error(data_simul_Estim(orig_vals = numeric(0), n = 100, distrib = "exp"), "orig_vals must not be empty.")
})

# # Test 5: Error handling - unsupported distribution
# test_that("Test 5: Error handling - unsupported distribution", {
#   expect_error(data_simul_Estim(orig_vals = dat$V1, n = 100, distrib = "unsupported_dist"), "Unsupported distribution. Supported distributions are: inverse_gamma, llogis, gumbel, exp")
# })

# Test 6: Error handling - non-numeric n
test_that("Test 6: Error handling - non-numeric n", {
  expect_error(data_simul_Estim(orig_vals = dat$V1, n = "non-numeric", distrib = "exp"), "n must be a positive integer.")
})

# Test 7: Error handling - negative n
test_that("Test 7: Error handling - negative n", {
  expect_error(data_simul_Estim(orig_vals = dat$V1, n = -100, distrib = "exp"), "n must be a positive integer.")
})

# Test 8: Handling of NULL n
test_that("Test 8: Handling of NULL n", {
  simulated_data <- data_simul_Estim(orig_vals = dat$V1, n = NULL, distrib = "exp")
  expect_length(simulated_data, length(dat$V1))
  expect_type(simulated_data, "double")
})

# Test 12: Reproducibility check
test_that("Test 12: Reproducibility of results with set seed", {
  set.seed(123)
  a <- data_simul_Estim(orig_vals = dat$V1, n = 100, distrib = "exp")
  set.seed(123)
  b <- data_simul_Estim(orig_vals = dat$V1, n = 100, distrib = "exp")
  expect_identical(a, b)
})

