% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_area_water.R
\name{remove_area_water}
\alias{remove_area_water}
\title{remove_area_water}
\usage{
remove_area_water(
  x,
  vintage = 2020,
  output_dir = tempdir(),
  delete_files = TRUE
)
}
\arguments{
\item{x}{An sf shapefile object with possible areas of water downloaded from the Census Bureau}

\item{vintage}{An integer that specifies the year of the shapefile. The default is 2020.}

\item{output_dir}{A full directory path where supportive shapefiles and their associated files will be downloaded.
The default is the directory defined by the value returned by \code{tempdir()}.}

\item{delete_files}{A logical which if \code{TRUE} will delete the shapefile and associated files in 'output_dir'.
The default is TRUE.}
}
\value{
An sf object with the water area geometries removed.
}
\description{
Function removes water area geometries from downloaded Census Bureau shapefiles
}
\examples{
\dontrun{
  # Request for Census Bureau data plus CPU processing can exceed well over 10
  #  seconds in some cases.
  library(downloader)
  library(sf)
  library(usmap)
  library(withr)
  library(data.table)
  library(RcensusPkg)

  # Remove water areas from New York, New York sf object
  ny_state_county_fips <- usmap::fips(state = "New York", county = "New York")
  ny_state_fips <- substr(ny_state_county_fips, 1,2)
  ny_county_fips <- substr(ny_state_county_fips, 3, 5)

  # Define a temporary output folder for the downloaded shapefiles
  output_dir <- withr::local_tempdir()
  if(!dir.exists(output_dir)){
    dir.create(output_dir)
  }

  # Define an expression for filtering just the New York county
  express <- parse(text = paste0("COUNTYFP == ", '"', ny_county_fips, '"'))

  # Get the New York,New York county tract sf geometries object
  ny_tracts_sf <- RcensusPkg::tiger_tracts_sf(
    state = ny_state_fips,
    vintage = 2020,
    general = FALSE,
    transform_crs = 6538,
    express = express,
    output_dir = output_dir,
    delete_files = FALSE
  )

  # Remove the area waters from New York, New York sf object
    ny_without_water_sf <- RcensusPkg::remove_area_water(
    ny_tracts_sf,
    output_dir = output_dir,
    delete_files = FALSE
  )
}
}
