#' @title bedload transport data
#'
#' @description A dataset containing  the discharge, the bedload transport rate
#'  The variables are as follows:
#' @format A data frame with 76 rows and 2 variables
#' \describe{
#'   \item{x}{the discharge (cubic meters/second)}
#'   \item{y}{the bedload transport rate (kilograms/second)}
#' }
#'
#' @source Ryan, S., Porth, L., Troendle, C. (2002).
#'
#' @docType data
#' @keywords data_transport
#' @usage data(data_transport)
#'
#' @references
#'  \itemize{
#'   \item Ryan, S., Porth, L., Troendle, C. (2002).
#' Defining phases of bedload transport
#' using piecewise regression.
#' Earth Surface Processes and Landforms 27, 971--990.
#'
#'   \item Ryan, S., Porth, L. (2007). A tutorial on the piecewise
#' regression approach applied to bedload transport data.
#' US Department of Agriculture, Forest Service,
#' Rocky Mountain Research Station Fort Collins, CO, 1--41.
#' }
#'
#' @examples
#' data(data_transport)
#' summary(data_transport)



"data_transport"
