% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-nbinomial-walk.R
\name{random_negbinomial_walk}
\alias{random_negbinomial_walk}
\title{Generate Multiple Random Negative Binomial Walks}
\usage{
random_negbinomial_walk(
  .num_walks = 25,
  .n = 100,
  .size = 1,
  .prob = 0.5,
  .mu = NULL,
  .initial_value = 0,
  .samp = TRUE,
  .replace = TRUE,
  .sample_size = 0.8,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{An integer specifying the number of random walks to
generate. Default is 25.}

\item{.n}{Integer. Number of random variables to return for each walk. Default is 100.}

\item{.size}{Integer. Number of successful trials or dispersion parameter. Default is 1.
This must also match the number of dimensions, for example if \code{.dimensions = 3}, then
.size must be a vector of length 3 like \code{c(1, 2, 3)}.}

\item{.prob}{Numeric. Probability of success in each trial (0 < prob <= 1). Default is 0.5.
This must also match the number of dimensions, for example if \code{.dimensions = 3}, then
.prob must be a vector of length 3 like \code{c(0.5, 0.7, 0.9)}.}

\item{.mu}{Numeric. Alternative parametrization via mean. Default is NULL.
This must also match the number of dimensions, for example if \code{.dimensions = 3}, then
.mu must be a vector of length 3 like \code{c(1, 2, 3)}.}

\item{.initial_value}{Numeric. Starting value of the walk. Default is 0.}

\item{.samp}{Logical. Whether to sample the steps. Default is TRUE.}

\item{.replace}{Logical. Whether sampling is with replacement. Default is TRUE.}

\item{.sample_size}{Numeric. Proportion of steps to sample (0-1). Default is 0.8.}

\item{.dimensions}{Integer. Number of dimensions (1, 2, or 3). Default is 1.}
}
\value{
A tibble containing the generated random walks with columns depending
on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}
}
\description{
A Negative Binomial random walk is a stochastic process in which each step is
drawn from the Negative Binomial distribution, commonly used for modeling count
data with overdispersion. This function allows for the simulation of multiple
independent random walks in one, two, or three dimensions, with user control over
the number of walks, steps, and the distribution parameters. Sampling options
allow for further customization, including the ability to sample a proportion of
steps and to sample with or without replacement. The resulting data frame includes
cumulative statistics for each walk, making it suitable for simulation studies and
visualization.
}
\details{
The \code{random_negbinomial_walk} function generates multiple random walks in
1, 2, or 3 dimensions. Each walk is a sequence of steps where each step is
a random draw from the Negative Binomial distribution using \code{stats::rnbinom()}.
The user can specify the number of samples in each walk (\code{n}), the size parameter,
the probability of success (\code{prob}), and/or the mean (\code{mu}), and the number of
dimensions. The function also allows for sampling a proportion of the steps and
optionally sampling with replacement.
}
\examples{
set.seed(123)
random_negbinomial_walk()

set.seed(123)
random_negbinomial_walk(.dimensions = 3,
  .size = c(1,2,3),
  .prob = c(0.5,0.7,0.9)
  ) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Discrete Distribution: 
\code{\link{discrete_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Discrete Distribution}
\concept{Generator Functions}
