% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{rw_client}
\alias{rw_client}
\title{Random walk simulation}
\usage{
rw_client(v, g, data)
}
\arguments{
\item{v}{The initial vertex of the input graph.}

\item{g}{The input graph. It should be a transactional graph with the amount as the attribute of each edge. The vertices must be the clients IDs.}

\item{data}{Dataframe with information of the clients. It should include a column with the clients IDs named "customer_id" and the alert label named "sar_flag" that must be a boolean variable.}
}
\value{
A vector with the number of steps taken in the random walk and the total transactioned amount in it.
}
\description{
Computes a random walk path for a given client.
}
\examples{
g <- igraph::graph_from_data_frame(d = transactions_small_example[, 1:3], directed = TRUE)
v <- transactions_small_example[1, 1]
rw_client(v, g, data = clients_small_example)
}
\references{
Eddin, A. N., Bono, J., Aparício, D., Polido, D., Ascensao, J. T., Bizarro, P., and Ribeiro, P. (2021). Anti-money laundering alert optimization using machine learning with graphs. arXiv preprint arXiv:2112.07508.
}
