% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_range}
\alias{rx_range}
\title{Match any character within the range defined by the parameters.}
\usage{
rx_range(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Range of characters. The method expects an even number of
parameters; unpaired parameters are ignored.}
}
\description{
Value parameter will be interpreted as pairs. For example,
\code{range(c('a', 'z', '0', '9'))} will be interpreted to mean any
character within the ranges a–z (ascii x–y) or 0–9 (ascii x–y). The method
expects an even number of parameters; unpaired parameters are ignored.
}
\examples{
rx_range(value = c('1', '3'))

# create an expression
x <- rx_range(value = c('1', '3'))

grepl(x, "2") # should be true
grepl(x, "4") # should be false
}
