% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreadOption.R
\name{spreadOption}
\alias{spreadOption}
\title{Kirk's Approximation for Spread Option Pricing}
\usage{
spreadOption(F1, F2, X, sigma1, sigma2, rho, T2M, r, type = "call")
}
\arguments{
\item{F1}{numeric, the forward price of the first asset.}

\item{F2}{numeric, the forward price of the second asset.}

\item{X}{numeric, the strike price of the spread option.}

\item{sigma1}{numeric, the volatility of the first asset (annualized).}

\item{sigma2}{numeric, the volatility of the second asset (annualized).}

\item{rho}{numeric, the correlation coefficient between the two assets (-1 <= rho <= 1).}

\item{T2M}{numeric, the time to maturity in years.}

\item{r}{numeric, the risk-free interest rate (annualized).}

\item{type}{character, the type of option to evaluate, either "call" or "put".
Default is "call".}
}
\value{
A list containing the following elements:
\itemize{
\item \code{price}: The price of the spread option
\item \code{delta_F1}: The sensitivity of the option price to changes in F1
\item \code{delta_F2}: The sensitivity of the option price to changes in F2
\item \code{gamma_F1}: The second derivative of the option price with respect to F1
\item \code{gamma_F2}: The second derivative of the option price with respect to F2
\item \code{gamma_cross}: The mixed second derivative with respect to F1 and F2
\item \code{vega_1}: The sensitivity of the option price to changes in sigma1
\item \code{vega_2}: The sensitivity of the option price to changes in sigma2
\item \code{theta}: The sensitivity of the option price to the passage of time
\item \code{rho}: The sensitivity of the option price to changes in the interest rate
}
}
\description{
Computes the price and Greeks of European spread options using Kirk's 1995
approximation. The spread option gives the holder the right to receive the
difference between two asset prices (F2 - F1) at maturity, if positive,
in exchange for paying the strike price X.
}
\details{
Kirk's approximation is particularly useful for spread options where the exercise
price is zero or small relative to the asset prices. The approximation assumes
that the ratio of the assets follows a lognormal distribution.

The implementation includes a small constant (epsilon) to avoid numerical
instabilities that might arise from division by zero.
}
\examples{
# Price a call spread option with the following parameters:
F1 <- 100  # Forward price of first asset
F2 <- 110  # Forward price of second asset
X <- 5     # Strike price
sigma1 <- 0.2  # Volatility of first asset
sigma2 <- 0.25 # Volatility of second asset
rho <- 0.5     # Correlation between assets
T2M <- 1       # One year to maturity
r <- 0.05      # Risk-free rate

result_call <- spreadOption(F1, F2, X, sigma1, sigma2, rho, T2M, r, type = "call")
result_put <- spreadOption(F1, F2, X, sigma1, sigma2, rho, T2M, r, type = "put")

}
\references{
Kirk, E. (1995) "Correlation in the Energy Markets." Managing Energy Price Risk,
Risk Publications and Enron, London, pp. 71-78.
}
