% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bond.R
\name{bond}
\alias{bond}
\title{Bond pricing}
\usage{
bond(ytm = 0.05, C = 0.05, T2M = 1, m = 2, output = "price")
}
\arguments{
\item{ytm}{Yield to Maturity. \code{numeric}}

\item{C}{Coupon rate per annum. \code{numeric}}

\item{T2M}{Time to maturity in years. \code{numeric}}

\item{m}{Periods per year for coupon payments e.g semi-annual = 2. \code{numeric}}

\item{output}{"price", "df" or "duration". \code{character}}
}
\value{
Returns price \code{numeric}, cash flows \code{tibble}, or duration \code{numeric}
}
\description{
Compute bond price, cash flow table or duration
}
\examples{
bond(ytm = 0.05, C = 0.05, T2M = 1, m = 2, output = "price")
bond(ytm = 0.05, C = 0.05, T2M = 1, m = 2, output = "df")
bond(ytm = 0.05, C = 0.05, T2M = 1, m = 2, output = "duration")
}
\author{
Philippe Cote
}
