% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit_bds}
\alias{fit_bds}
\title{fits the bds model}
\usage{
fit_bds(
  phy,
  sampling_fraction,
  lambda_hat,
  mu_hat,
  eta,
  num_speciation_classes = 6,
  num_extinction_classes = 6,
  sd = 0.587,
  tol = 1e-06,
  condition_survival = TRUE,
  condition_root_speciation = TRUE,
  condition_marginal = FALSE,
  extinction_approximation = FALSE,
  verbose = FALSE,
  numthreads = 0
)
}
\arguments{
\item{phy}{an object of type phylo}

\item{sampling_fraction}{the probability that each species was sampled in the tree}

\item{lambda_hat}{the overall scale of the log-normal base distribution for the speciation rates. If not specified, the function will estimate it using ML}

\item{mu_hat}{the overall scale of the log-normal base distribution for the extinction rates. If not specified, the function will estimate it using ML}

\item{eta}{the shift rate parameter. If not specified, the function will estimate it using ML}

\item{num_speciation_classes}{the number of speciation rate class discretizations, such that rate categories is k = n_sp * n_mu}

\item{num_extinction_classes}{the number of extinction rate class discretizations, such that rate categories is k = n_sp * n_mu}

\item{sd}{the spread parameter for the log-normal base distribution}

\item{tol}{the local error threshold in the numerical ODE solver (per delta_t time step)}

\item{condition_survival}{whether or not to condition on the survival of the left and right lineages descending from the root (default TRUE)}

\item{condition_root_speciation}{whether or not to condition on that there was a speciation event at the root node (default TRUE)}

\item{condition_marginal}{whether or condition using the marginal or per-category approach (default FALSE, i.e., to condition per rate category)}

\item{extinction_approximation}{whether or not to approximate the extinction probability calculations, by assuming that rate shift events are not allowed on extinct lineages (default FALSE)}

\item{verbose}{whether or not to print more information}

\item{numthreads}{how many threads to use in likelihood calculation. If 0, then the program uses all available cores}
}
\value{
a list with three items: $model (the parameter estimates), $td (a tidytree object with branch-rate estimates), and $tip_rates (a data frame of the tip rates)
}
\description{
fits the bds model
}
\examples{
data("primates")

analysis <- fit_bds(primates, sampling_fraction = 0.6, numthreads = 2)


}
