% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.GEV.R
\name{pgev}
\alias{pgev}
\title{pgev}
\usage{
pgev(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE)
}
\arguments{
\item{q}{[vector] Vector of quantiles}

\item{loc}{[vector] Location parameter}

\item{scale}{[vector] Scale parameter}

\item{shape}{[vector] Shape parameter}

\item{lower.tail}{[bool] Return CDF if TRUE, else return survival function}
}
\value{
[vector] CDF (or SF) of GEV at x
}
\description{
Cumulative distribution function (or survival function) of Generalized 
Extreme Value distribution
}
\examples{
## Data
loc = 1
scale = 0.5
shape = -0.2
x = base::seq( -5 , 5 , length = 1000 )
cdfx = pgev( x , loc = loc , scale = scale , shape = shape )
}
