% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{asNifti}
\alias{asNifti}
\alias{retrieveNifti}
\alias{updateNifti}
\alias{asNifti.default}
\title{Create or modify an NIfTI image object}
\usage{
asNifti(x, reference = NULL, ...)

\method{asNifti}{default}(x, reference = NULL, datatype = "auto",
  internal = NA, ...)
}
\arguments{
\item{x}{Any suitable object (see Details).}

\item{reference}{An image, or a named list of NIfTI-1 properties like that
produced by \code{\link{niftiHeader}}. The default of \code{NULL} will
have no effect.}

\item{...}{Additional parameters to methods.}

\item{datatype}{The NIfTI datatype to use within the internal image. The
default, \code{"auto"} uses the R type. Other possibilities are
\code{"float"}, \code{"int16"}, etc., which may be preferred to reduce
object size. However, no checks are done to ensure that the coercion
maintains precision, and this option is for advanced usage only.}

\item{internal}{Logical value. If \code{FALSE}, the result will be an array
of class \code{"niftiImage"} containing the image pixel or voxel values,
with some metadata in attributes. If \code{TRUE}, the result will be an
object of class \code{"internalImage"}, which exposes some basic metadata
to R but stores the pixel data internally. If \code{NA}, the default, the
result will be an internal image only if the input \code{image} is. If a
new \code{datatype} is set then this value is implicitly \code{TRUE}.}
}
\value{
An array or internal image, with class \code{"niftiImage"} (and
  possibly also \code{"internalImage"}).
}
\description{
This function converts a filename, array or other image class into an object
of class \code{"niftiImage"}, and optionally updates its metadata from a
reference image and/or changes its internal datatype. The dimensions and
pixel dimensions from the \code{image} will replace those from the reference
object, if they are available.
}
\details{
If the \code{image} has an internal NIfTI pointer, that will be retrieved
directly. Otherwise, if it is a string, it will be taken to be a filename.
If it looks like a \code{"nifti"} object (from package \code{oro.nifti}),
or an \code{"MriImage"} object (from package \code{tractor.base}), a
conversion will be performed. A list will be assumed to be of the form
produced by \code{\link{niftiHeader}}. Finally, a numeric array or matrix,
or RGB array, will be converted using default image parameters.

If \code{reference} is a complete list of NIfTI-1 header fields, like that
produced by \code{\link{niftiHeader}}, or an image, then it will be used to
create the internal object, and then the data and metadata associated with
the \code{image} will overwrite the appropriate parts. If \code{reference}
is an incomplete list, the \code{image} will be used to create the internal
object, and then the specified fields will be overwritten from the list.
This allows users to selectively update certain fields while leaving others
alone (but see the note below).

If multiple values are passed for a field that expects a scalar (which is
most of them), the first element of the vector will be used, with a warning.
An empty vector will be ignored, also with a warning. If a value of the
wrong length is passed to a vector-valued field, an error will be generated.

Datatype information in a list \code{reference} is ignored. The datatype can
only be changed using the \code{datatype} argument, but in this case the
internal object gets out of sync with the R array, so an internal image is
returned to avoid the mismatch. Changing the internal datatype in this way
is for advanced usage only.

\code{retrieveNifti} and \code{updateNifti} are soft-deprecated alternative
interfaces to this function, which behave like the pre-existing functions of
the same names. They may be removed in future.
}
\note{
The \code{scl_slope} and \code{scl_inter} fields affect the numerical
  interpretation of the pixel data, so it is impossible in general to change
  them without also changing the array values on both the C and the R side.
  Therefore, to avoid unexpected side-effects, these fields are not affected
  by this function. The \code{dim} and \code{pixdim} fields can be changed,
  but for most users the accessor functions of the same name are much safer,
  and should be used in preference.
}
\seealso{
\code{\link{readNifti}}, \code{\link{$.niftiImage}},
  \code{\link{dim.internalImage}}, \code{\link{pixdim}}, \code{\link{xform}}
}
\author{
Jon Clayden <code@clayden.org>
}
