% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpca_c.R
\name{mlpca_c}
\alias{mlpca_c}
\title{Maximum likelihood principal component analysis for mode C error conditions}
\usage{
mlpca_c(X, Xsd, p, MaxIter = 20000)
}
\arguments{
\item{X}{MxN matrix of measurements}

\item{Xsd}{MxN matrix of measurements error standard deviations}

\item{p}{Rank of the model's subspace, p must be than the minimum of M and N}

\item{MaxIter}{Maximum no. of iterations}
}
\value{
The parameters returned are the results of SVD on the estimated
subspace. The quantity Ssq represents the sum of squares of weighted
residuals. ErrFlag indicates the convergence condition,
with 0 indicating normal termination and 1 indicating the maximum number of
iterations have been exceeded.
}
\description{
Performs maximum likelihood principal components analysis for
mode C error conditions (independent errors, general heteroscedastic
case).
Employs ALS algorithm.
}
\details{
The returned parameters, U, S and V, are analogs to the
truncated SVD solution, but have somewhat different properties since they
represent the MLPCA solution. In particular, the solutions for different
values of p are not necessarily nested (the rank 1 solution may not be in
the space of the rank 2 solution) and the eigenvectors do not necessarily
account for decreasing amounts of variance, since MLPCA is a subspace
modeling technique and not a variance modeling technique.
}
\examples{

library(RMLPCA)
data(data_clean)
data(data_error_c)
data(sds_c)

# data that you will usually have on hands
data_noisy <- data_clean + data_error_c

# run mlpca_c with rank p = 5
results <- RMLPCA::mlpca_c(
  X = data_noisy,
  Xsd = sds_c,
  p = 2
)

# estimated clean dataset
data_cleaned_mlpca <- results$U \%*\% results$S \%*\% t(results$V)
}
\references{
Wentzell, P. D.
"Other topics in soft-modeling: maximum likelihood-based soft-modeling
methods." (2009): 507-558.
}
