% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ER.RMFM}
\alias{ER.RMFM}
\title{Select the structure dimension of factor matrix}
\usage{
ER.RMFM(
  X,
  r_max = 10,
  epsELBO = 1e-09,
  maxIter = 20,
  verbose = FALSE,
  seed = 1
)
}
\arguments{
\item{X}{a  p1* p2*T array, which is the observed  matrix from each individual, where T is the sample size.}

\item{r_max}{an optional positive integer, specify the upper bound of row and column factors; default as 10.}

\item{epsELBO}{an optional positive value, tolerance of relative variation rate of the variational lower bound value, default as '1e-9'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{an optional integer, specify the random seed for reproducibility in initialization.}
}
\value{
return a list including the following components:
\itemize{
  \item \code{rvec} - a two-dimensional vector, the estimated row and column numbers of factors.
  \item \code{svrMat} - a r_max-by-2 matrix, the singular value ratios.
}
}
\description{
Select the structure dimension of factor matrix in the high-dimensional robust matrix factor model
}
\details{
None
}
\examples{
r1 <- 4; r2 <- 3;
Tt <- 100; type <- 'MatrixT'
p1 <- 50; p2 <- 50
datlist <- gendata_rmfm(Tt = Tt,p1 =p1, p2=p2, r1=r1, r2=r2,
                        rho=1, type= 'MatrixT', nu=3)
str(datlist)
res <- ER.RMFM(datlist$X, r_max=10,   epsELBO=1e-9, maxIter=10, verbose=FALSE, seed=1)
res
}
\references{
None
}
\seealso{
None
}
