% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{create_splits}
\alias{create_splits}
\alias{holdout}
\alias{cv_folds}
\title{Create splits of observed data cells for hyperparameter tuning}
\usage{
create_splits(indices, control)

holdout(indices, pct = 0.1, R = 10L)

cv_folds(indices, K = 5L)
}
\arguments{
\item{indices}{an integer vector giving the indices of observed cells in a 
data matrix.}

\item{control}{a control object inheriting from class 
\code{"split_control"} as generated by \code{\link{holdout_control}()} 
for repeated holdout validation or \code{\link{cv_folds_control}()} for 
\eqn{K}-fold cross-validation.}

\item{pct}{numeric in the interval (0, 1); the percentage of observed cells 
in the data matrix to be randomly selected into the validation set (defaults 
to 0.1).}

\item{R}{an integer giving the number of random splits into training and 
validation sets (defaults to 10).}

\item{K}{an integer giving the number of cross-validation folds (defaults 
to 5).}
}
\value{
A list of index vectors giving the validation sets of the 
respective replication or cross-validation fold.
}
\description{
Split the observed cells of a data matrix into training and validation sets 
for hyperparameter tuning.  Methods are available for repeated holdout 
validation and \eqn{K}-fold cross-validation.
}
\details{
Functions \code{holdout()} and \code{cv_folds()} are wrapper 
functions that first call \code{\link{holdout_control}()} and 
\code{\link{cv_folds_control}()}, respectively, before calling 
\code{create_splits()}.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# set up validation sets so that methods use same data splits
set.seed(20250723)
observed <- which(!is.na(MovieLensToy))
holdout_splits <- holdout(observed, R = 5)
# robust discrete matrix completion with hyperparameter tuning
fit_RDMC <- rdmc_tune(
  MovieLensToy, 
  lambda = fraction_grid(nb_lambda = 6),
  splits = holdout_splits
)
# Soft-Impute with discretization step and hyperparameter tuning
fit_SI <- soft_impute_tune(
  MovieLensToy, 
  lambda = fraction_grid(nb_lambda = 6, reverse = TRUE),
  splits = holdout_splits
)
# extract optimal values of regularization parameter
get_lambda(fit_RDMC)
get_lambda(fit_SI)

}
\seealso{
\code{\link{holdout_control}()}, \code{\link{cv_folds_control}()}, 

\code{\link{rdmc_tune}()}, \code{\link{soft_impute_tune}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
