% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\name{dispersion}
\alias{dispersion}
\title{Obtain the eigenvalue spacings of a matrix or ensemble of matrices.}
\usage{
dispersion(
  array,
  pairs = NA,
  norm_order = TRUE,
  singular = FALSE,
  pow_norm = 1
)
}
\arguments{
\item{array}{a square matrix or matrix ensemble whose eigenvalue spacings are to be returned}

\item{pairs}{a string argument representing the pairing scheme to use}

\item{norm_order}{sorts the eigenvalue spectrum by its norms if TRUE, otherwise sorts them by sign}

\item{singular}{return the singular values of the matrix or matrix ensemble}

\item{pow_norm}{power to raise norm to - defaults to 1 (the standard absolute value); otherwise raises norm to the power of argument (beta norm)}
}
\value{
A tidy dataframe with the real & imaginary components of the eigenvalues and their norms along with a unique index.
}
\description{
Returns a vector of the eigenvalue spacings of a random matrix or ensemble.
}
\examples{
# Eigenvalue dispersion of a normal matrix using the lower pair scheme
P <- RM_norm(N = 5)
disp_P <- dispersion(P, pairs = "lower")

# Eigenvalue dispersion of a stochastic matrix (using the consecutive pair scheme)
Q <- RM_stoch(N = 5)
disp_Q <- dispersion(Q)

# Eigenvalue dispersion of an normal matrix ensemble, ordering by sign instead of norm.
ens <- RME_beta(N = 10, beta = 2, size = 10)
disp_ens <- dispersion(ens, norm_order = FALSE)

}
