% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estBeta.R
\name{estBeta}
\alias{estBeta}
\title{Estimate the parameters of Beta distribution given leaf angle measurements.}
\usage{
estBeta(LeafAngles)
}
\arguments{
\item{LeafAngles}{The leaf angle measurements.}
}
\value{
the parameters of Beta distribution.
}
\description{
Estimate the parameters of Beta distribution given leaf angle measurements.
}
\examples{
angleZ<-c(4.5, 13.5, 22.5, 31.5, 40.5, 49.5, 58.5, 67.5, 76.5, 85.5)
angleA<-c(10,30,50,70,90,110,130,150,170,190,210,230,250,270,290,310,330,350)
sADis<-sysAziDis()
sZDis<-sphericalDis()
for(solarZenith in 10:80)
{
  print(computeG(angleZ,sZDis,angleA,sADis,solarZenith,40))
}


}
\references{
Wang, W. M., Li, Z. L., & Su, H. B. (2007). 
Comparison of leaf angle distribution functions: effects on extinction coefficient and 
fraction of sunlit foliage. Agricultural and Forest Meteorology, 143(1), 106-122.
}
\author{
Wei-Min Wang (wmwang AT gmail.com)
}
