% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_jalalidate_generic_functions.R
\name{as.character.JalaliDate}
\alias{as.character.JalaliDate}
\alias{as.Date.JalaliDate}
\alias{as.list.JalaliDate}
\title{data type conversion}
\usage{
\method{as.character}{JalaliDate}(
  x,
  format = "A",
  separator = jdate_options("DEFAULT_SEPARATOR"),
  ...
)

\method{as.Date}{JalaliDate}(x, ...)

\method{as.list}{JalaliDate}(x, ...)
}
\arguments{
\item{x}{JalaliDate object}

\item{format}{character.
One of c("A", "B", "C") elements:
\itemize{
 \item{"A": simple, combining Jalali date with DEFAULT_SEPARATOR}
 \item{"B": (year) (month_name) (day)}
 \item{"C": (year) (month_name) (day) (day_of_week)}
 }}

\item{separator}{character.
One of VALID_SEPARATORS (see \link{jdopt_get_options}) that converts Jalali date elements to character}

\item{...}{\itemize{
\item{"as.character": The ... argument is used to pass options that overrides current options (see examples).}
\item{"other": future usage}}}
}
\value{
character, Date, or list
}
\description{
convert JalaliDate to character, Date, or list
}
\examples{
as.character(JalaliDate(1), separator= "+", VALID_SEPARATORS = c("+"))
}
