/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.Simplifying;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class SymmetricFrequencyResponse2 {
    public static final double TwoPi = Math.PI * 2;
    private static Matrix g_u;
    private final Polynomial m_p;

    private static synchronized Matrix _transform(int r) {
        if (g_u == null || g_u.getRowsCount() < r) {
            g_u = SymmetricFrequencyResponse2.transform(r);
        }
        return g_u;
    }

    public static SymmetricFrequencyResponse2 createFromFilter(IFiniteFilter f) {
        return new SymmetricFrequencyResponse2(SymmetricFilter.createFromFilter(f));
    }

    private static void D2SFR(double[] c) {
        int q = c.length;
        int i = 1;
        while (i < q) {
            int n = i++;
            c[n] = c[n] * 2.0;
        }
        if (q > 2) {
            Matrix u = SymmetricFrequencyResponse2._transform(q);
            UpperTriangularMatrix.rmul(u, c);
        }
    }

    private static void SFR2D(double[] c) throws MatrixException {
        int q = c.length;
        if (q > 2) {
            Matrix u = SymmetricFrequencyResponse2._transform(q);
            UpperTriangularMatrix.rsolve(u, c);
        }
        int i = 1;
        while (i < q) {
            int n = i++;
            c[n] = c[n] / 2.0;
        }
    }

    private static Polynomial sfrur(Complex ur) {
        double a = ur.getRe();
        if (ur.getIm() == 0.0) {
            return Polynomial.valueOf(2.0, -2.0 / a);
        }
        double[] s = new double[]{2.0 + 4.0 * a * a, -4.0 * a, 1.0};
        SymmetricFrequencyResponse2.D2SFR(s);
        return Polynomial.of(s);
    }

    static Matrix transform(int rank) {
        Matrix U = new Matrix(rank, rank);
        U.set(0, 0, 1.0);
        U.set(1, 1, 0.5);
        for (int c = 2; c < rank; ++c) {
            U.set(0, c, -U.get(0, c - 2));
            for (int r = 1; r < c - 1; ++r) {
                U.set(r, c, -U.get(r, c - 2) + U.get(r - 1, c - 1));
            }
            U.set(c - 1, c, U.get(c - 2, c - 1));
            U.set(c, c, U.get(c - 1, c - 1));
        }
        return U;
    }

    public SymmetricFrequencyResponse2(Polynomial p) {
        this.m_p = p;
    }

    public SymmetricFrequencyResponse2(SymmetricFilter sf) {
        double[] n = sf.getCoefficients();
        SymmetricFrequencyResponse2.D2SFR(n);
        this.m_p = Polynomial.of(n).adjustDegree();
    }

    public SymmetricFrequencyResponse2 divide(SymmetricFrequencyResponse2 r) {
        Polynomial p = this.m_p.divide(r.m_p).adjustDegree();
        return new SymmetricFrequencyResponse2(p);
    }

    public double evaluateAt(double freq) {
        return this.evaluateAt2Cos(2.0 * Math.cos(freq));
    }

    public double evaluateAt2Cos(double twocos) {
        return this.m_p.evaluateAt(twocos);
    }

    public double get(int idx) {
        return this.m_p.get(idx);
    }

    public Polynomial getPolynomial() {
        return this.m_p;
    }

    public int getDegree() {
        return this.m_p.getDegree();
    }

    public double getIntegral() {
        double var = this.m_p.get(0);
        double icos = 1.0;
        for (int i = 2; i <= this.m_p.getDegree(); i += 2) {
            icos *= (double)(4 * (i - 1));
            var += this.m_p.get(i) * (icos /= (double)i);
        }
        return var;
    }

    public SymmetricFrequencyResponse2 minus(double d) {
        Polynomial p = this.m_p.minus(d);
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFrequencyResponse2 minus(SymmetricFrequencyResponse2 r) {
        Polynomial p = this.m_p.minus(r.m_p).adjustDegree();
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFrequencyResponse2 negate() {
        Polynomial p = this.m_p.negate();
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFrequencyResponse2 plus(double d) {
        Polynomial p = this.m_p.plus(d);
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFrequencyResponse2 plus(SymmetricFrequencyResponse2 r) {
        Polynomial p = this.m_p.plus(r.m_p).adjustDegree();
        return new SymmetricFrequencyResponse2(p);
    }

    public Complex[] roots() {
        return this.m_p.roots();
    }

    public Complex[] roots(IRootsSolver searcher) {
        return this.m_p.roots(searcher);
    }

    public SymmetricFrequencyResponse2 times(double d) {
        Polynomial p = this.m_p.times(d);
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFrequencyResponse2 times(SymmetricFrequencyResponse2 r) {
        Polynomial p = this.m_p.times(r.m_p).adjustDegree();
        return new SymmetricFrequencyResponse2(p);
    }

    public SymmetricFilter toSymmetricFilter() throws MatrixException {
        double[] c = this.m_p.getCoefficients();
        SymmetricFrequencyResponse2.SFR2D(c);
        return SymmetricFilter.of(c);
    }

    public static class SimplifyingTool
    extends Simplifying<SymmetricFrequencyResponse2> {
        @Override
        public boolean simplify(SymmetricFrequencyResponse2 left, BackFilter urb) {
            this.clear();
            if (left.m_p.getDegree() == 0) {
                return false;
            }
            Complex[] roots = urb.roots();
            if (roots == null) {
                return false;
            }
            Polynomial P = left.m_p;
            Polynomial Q = null;
            Polynomial R = null;
            for (int i = 0; i < roots.length; ++i) {
                if (!(roots[i].getIm() >= 0.0)) continue;
                Polynomial D = SymmetricFrequencyResponse2.sfrur(roots[i]);
                Polynomial.Division div = Polynomial.divide(P, D);
                if (div.isExact()) {
                    P = div.getQuotient();
                    if (Q == null) {
                        Q = D;
                        continue;
                    }
                    Q = Q.times(D);
                    continue;
                }
                R = R == null ? D : R.times(D);
            }
            if (Q == null) {
                return false;
            }
            this.m_left = new SymmetricFrequencyResponse2(P);
            this.m_right = R == null ? new SymmetricFrequencyResponse2(Polynomial.ONE) : new SymmetricFrequencyResponse2(R);
            this.m_common = new SymmetricFrequencyResponse2(Q);
            return true;
        }

        @Override
        public boolean simplify(SymmetricFrequencyResponse2 left, SymmetricFrequencyResponse2 right) {
            Polynomial rp;
            this.clear();
            if (left.m_p.getDegree() == 0 || right.m_p.getDegree() == 0) {
                return false;
            }
            Polynomial.SimplifyingTool psimp = new Polynomial.SimplifyingTool();
            Polynomial lp = left.m_p;
            if (psimp.simplify(lp, rp = right.m_p)) {
                lp = (Polynomial)psimp.getLeft();
                rp = (Polynomial)psimp.getRight();
                Polynomial p = (Polynomial)psimp.getCommon();
                this.m_common = new SymmetricFrequencyResponse2(p);
                this.m_left = new SymmetricFrequencyResponse2(lp);
                this.m_right = new SymmetricFrequencyResponse2(rp);
                return true;
            }
            return false;
        }
    }
}

