/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.IX11Preprocessor;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.regression.AdditiveOutlier;
import ec.tstoolkit.timeseries.regression.LevelShift;
import ec.tstoolkit.timeseries.regression.SeasonalOutlier;
import ec.tstoolkit.timeseries.regression.TransitoryChange;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class DefaultPreprocessor
extends DefaultX11Algorithm
implements IX11Preprocessor {
    private final PreprocessingModel model_;
    private final IPreprocessingFilter filter_;
    private final boolean noapply;

    public DefaultPreprocessor(PreprocessingModel model, IPreprocessingFilter filter, boolean noapply) {
        this.model_ = model;
        this.filter_ = filter;
        this.noapply = noapply;
    }

    @Override
    public void preprocess(InformationSet info) {
        TsData s = this.filter_.getCorrectedSeries(false);
        TsData fs = this.filter_.getCorrectedForecasts(false);
        TsData bs = this.filter_.getCorrectedBackcasts(false);
        TsData sall = s.update(fs);
        if (bs != null) {
            sall = bs.update(sall);
        }
        InformationSet atables = info.subSet("a-tables");
        InformationSet btables = info.subSet("b-tables");
        btables.set("b1", sall);
        if (fs != null) {
            atables.set("a1a", this.model_.forecast(fs.getLength(), false));
        }
        if (bs != null) {
            atables.set("a1b", this.model_.backcast(bs.getLength(), false));
        }
        if (this.noapply) {
            return;
        }
        TsDomain domain = this.model_.description.getSeriesDomain();
        int nf = this.context.getForecastHorizon();
        int nb = this.context.getBackcastHorizon();
        int ny = this.context.getFrequency();
        domain = domain.extend(nb, nf == 0 ? ny : nf);
        TsData mh = this.model_.movingHolidaysEffect(domain);
        TsData td = this.model_.tradingDaysEffect(domain);
        this.model_.backTransform(td, false, true);
        this.model_.backTransform(mh, false, false);
        atables.add("a6", td);
        atables.add("a7", mh);
        TsData p = this.model_.outliersEffect(domain);
        TsData pt = this.model_.deterministicEffect(domain, LevelShift.class);
        TsData ps = this.model_.deterministicEffect(domain, SeasonalOutlier.class);
        TsData pa = this.model_.deterministicEffect(domain, AdditiveOutlier.class);
        TsData pc = this.model_.deterministicEffect(domain, TransitoryChange.class);
        TsData ut = this.model_.userEffect(domain, ComponentType.Trend);
        TsData ua = this.model_.userEffect(domain, ComponentType.Irregular);
        TsData us = this.model_.userEffect(domain, ComponentType.Seasonal);
        TsData usa = this.model_.userEffect(domain, ComponentType.SeasonallyAdjusted);
        TsData uu = this.model_.userEffect(domain, ComponentType.Undefined);
        TsData user = this.model_.userEffect(domain, ComponentType.Series);
        pt = TsData.add(pt, ut);
        ps = TsData.add(ps, us);
        pa = TsData.add(pa, ua);
        TsData pi = TsData.add(pa, pc);
        TsData pall = TsData.add(pt, TsData.add(ps, pi));
        TsData u = TsData.add(usa, user);
        this.model_.backTransform(p, false, false);
        this.model_.backTransform(pt, false, false);
        this.model_.backTransform(ps, false, false);
        this.model_.backTransform(pa, false, false);
        this.model_.backTransform(pc, false, false);
        this.model_.backTransform(pi, false, false);
        this.model_.backTransform(pall, false, false);
        this.model_.backTransform(usa, false, false);
        this.model_.backTransform(uu, false, false);
        this.model_.backTransform(user, false, false);
        this.model_.backTransform(u, false, false);
        atables.add("a8t", pt);
        atables.add("a8s", ps);
        atables.add("a8i", pi);
        atables.add("a8", pall);
        atables.add("a9", u);
        atables.add("a9sa", usa);
        atables.add("a9u", uu);
        atables.add("a9ser", user);
    }
}

