% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-transformer.R
\name{data_transformer}
\alias{data_transformer}
\title{Data Transformer}
\value{
A class to transform (normalize or one hot encode) tabular data for RGAN
}
\description{
Provides a class to transform data for RGAN.
Method \verb{$new()} initializes a new transformer, method \verb{$fit(data)} learns
the parameters for the transformation from data (e.g. means and sds).
Methods \verb{$transform()} and \verb{$inverse_transform()} can be used to transform
and back transform a data set based on the learned parameters.
Currently, DataTransformer supports z-transformation (a.k.a. normalization)
for numerical features/variables and one hot encoding for categorical
features/variables. In your call to fit you just need to indicate which
columns contain discrete features.
}
\examples{
\dontrun{
# Before running the first time the torch backend needs to be installed
torch::install_torch()
# Load data
data <- sample_toydata()
# Build new transformer
transformer <- data_transformer$new()
# Fit transformer to data
transformer$fit(data)
# Transform data and store as new object
transformed_data <-  transformer$transform(data)
# Train the default GAN
trained_gan <- gan_trainer(transformed_data)
# Sample synthetic data from the trained GAN
synthetic_data <- sample_synthetic_data(trained_gan, transformer)
# Plot the results
GAN_update_plot(data = data,
synth_data = synthetic_data,
main = "Real and Synthetic Data after Training")
}

## ------------------------------------------------
## Method `data_transformer$fit`
## ------------------------------------------------

data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)

## ------------------------------------------------
## Method `data_transformer$transform`
## ------------------------------------------------

data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)
transformed_data <- transformer$transform(data)

## ------------------------------------------------
## Method `data_transformer$inverse_transform`
## ------------------------------------------------

data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)
transformed_data <- transformer$transform(data)
reconstructed_data <- transformer$inverse_transform(transformed_data)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{data_transformer$new()}}
\item \href{#method-fit_continuous}{\code{data_transformer$fit_continuous()}}
\item \href{#method-fit_discrete}{\code{data_transformer$fit_discrete()}}
\item \href{#method-fit}{\code{data_transformer$fit()}}
\item \href{#method-transform_continuous}{\code{data_transformer$transform_continuous()}}
\item \href{#method-transform_discrete}{\code{data_transformer$transform_discrete()}}
\item \href{#method-transform}{\code{data_transformer$transform()}}
\item \href{#method-inverse_transform_continuous}{\code{data_transformer$inverse_transform_continuous()}}
\item \href{#method-inverse_transform_discrete}{\code{data_transformer$inverse_transform_discrete()}}
\item \href{#method-inverse_transform}{\code{data_transformer$inverse_transform()}}
\item \href{#method-clone}{\code{data_transformer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new data_transformer object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_continuous"></a>}}
\if{latex}{\out{\hypertarget{method-fit_continuous}{}}}
\subsection{Method \code{fit_continuous()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$fit_continuous(column = NULL, data = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_discrete"></a>}}
\if{latex}{\out{\hypertarget{method-fit_discrete}{}}}
\subsection{Method \code{fit_discrete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$fit_discrete(column = NULL, data = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit a data_transformer to data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$fit(data, discrete_columns = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data set to transform}

\item{\code{discrete_columns}}{Column ids for columns with discrete/nominal values to be one hot encoded.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform_continuous"></a>}}
\if{latex}{\out{\hypertarget{method-transform_continuous}{}}}
\subsection{Method \code{transform_continuous()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$transform_continuous(column_meta, data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform_discrete"></a>}}
\if{latex}{\out{\hypertarget{method-transform_discrete}{}}}
\subsection{Method \code{transform_discrete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$transform_discrete(column_meta, data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
Transform data using a fitted data_transformer. (From original format to transformed format.)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$transform(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data set to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)
transformed_data <- transformer$transform(data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inverse_transform_continuous"></a>}}
\if{latex}{\out{\hypertarget{method-inverse_transform_continuous}{}}}
\subsection{Method \code{inverse_transform_continuous()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$inverse_transform_continuous(meta, data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inverse_transform_discrete"></a>}}
\if{latex}{\out{\hypertarget{method-inverse_transform_discrete}{}}}
\subsection{Method \code{inverse_transform_discrete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$inverse_transform_discrete(meta, data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inverse_transform"></a>}}
\if{latex}{\out{\hypertarget{method-inverse_transform}{}}}
\subsection{Method \code{inverse_transform()}}{
Inverse Transform data using a fitted data_transformer. (From transformed format to original format.)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$inverse_transform(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data set to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data <- sample_toydata()
transformer <- data_transformer$new()
transformer$fit(data)
transformed_data <- transformer$transform(data)
reconstructed_data <- transformer$inverse_transform(transformed_data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_transformer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
