% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDigitizedImage.R
\name{saveDigitizedImage}
\alias{saveDigitizedImage}
\title{Save to a file the structure image saved in an R data file with selected points.}
\usage{
saveDigitizedImage(
  nms,
  fileType = c("jpeg", "png", "pdf"),
  suffix = "_marked",
  res = 72,
  pch.show,
  col.show,
  cex.show,
  connect,
  col.connect,
  lwd.connect,
  col.scaleBar,
  lwd.scaleBar,
  showScaleBarLength,
  cex.scaleBar,
  showAnnuliLabels,
  annuliLabels,
  col.ann,
  cex.ann,
  offset.ann
)
}
\arguments{
\item{nms}{A string (or vector of strings) that indicates the R data file(s) created with \code{\link{digitizeRadii}}. If missing the user will be provided a dialog box from which to choose the file(s). The file(s) must be in the current working directory (see \code{\link{getwd}} result). May also be a single \code{RFishBC} object created with \code{\link{digitizeRadii}}.}

\item{fileType}{Choose file type to be \code{jpeg}, \code{png}, or \code{pdf}.}

\item{suffix}{A string that will be appended to each saved filename prior to the extension. Defaults to \dQuote{_marked}.}

\item{res}{Device (for jpeg and png) resolution. Defaults to 72.}

\item{pch.show}{See details in \code{\link{RFBCoptions}}.}

\item{col.show}{See details in \code{\link{RFBCoptions}}.}

\item{cex.show}{See details in \code{\link{RFBCoptions}}.}

\item{connect}{See details in \code{\link{RFBCoptions}}.}

\item{col.connect}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.connect}{See details in \code{\link{RFBCoptions}}.}

\item{col.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{showScaleBarLength}{See details in \code{\link{RFBCoptions}}.}

\item{cex.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{showAnnuliLabels}{See details in \code{\link{RFBCoptions}}.}

\item{annuliLabels}{See details in \code{\link{RFBCoptions}}.}

\item{col.ann}{See details in \code{\link{RFBCoptions}}.}

\item{cex.ann}{See details in \code{\link{RFBCoptions}}.}

\item{offset.ann}{See details in \code{\link{RFBCoptions}}.}
}
\value{
None, but a file is created in the working directory.
}
\description{
Save to a file the structure image with points to represent annuli that were saved to an R data file using \code{\link{digitizeRadii}}. This allows the user to create a file of their selections that could be printed.
}
\details{
None.
}
\examples{
## None because this requires interaction from the user.
## See the link to the extensive documentation in the Details.

}
\seealso{
\code{\link{showDigitizedImage}}, \code{\link{digitizeRadii}}, \code{\link{RFBCoptions}}, and \code{\link{jpeg}}, \code{\link{png}}, and \code{\link{pdf}}.
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
