% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findScalingFactor.R
\name{findScalingFactor}
\alias{findScalingFactor}
\title{Find scaling factor from object of known length}
\usage{
findScalingFactor(
  img,
  knownLength,
  windowSize,
  deviceType,
  closeWindow,
  col.scaleBar,
  lwd.scaleBar,
  pch.sel,
  col.sel,
  cex.sel,
  pch.del,
  col.del
)
}
\arguments{
\item{img}{A string that indicates the image (must be PNG, JPG, BMP, or TIFF) to be loaded and plotted. By default the user will be provided a dialog box from which to choose the file. Alternatively the user can supply the name of the file (will look for this file in the current working directory).}

\item{knownLength}{See details in \code{\link{RFBCoptions}}.}

\item{windowSize}{See details in \code{\link{RFBCoptions}}.}

\item{deviceType}{See details in \code{\link{RFBCoptions}}.}

\item{closeWindow}{See details in \code{\link{RFBCoptions}}.}

\item{col.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{pch.sel}{See details in \code{\link{RFBCoptions}}.}

\item{col.sel}{See details in \code{\link{RFBCoptions}}.}

\item{cex.sel}{See details in \code{\link{RFBCoptions}}.}

\item{pch.del}{See details in \code{\link{RFBCoptions}}.}

\item{col.del}{See details in \code{\link{RFBCoptions}}.}
}
\value{
A single numeric that is the scaling factor (a multiplier that is used to convert image lengths to actual lengths).
}
\description{
This computes a scaling factor (i.e., a multiplier that is used to convert image lengths to actual lengths) from user selected endpoints of an object of known length on the image given in \code{img} and the actual known length given in \code{knownLength}. See Details.
}
\details{
To apply the scaling factor determined with this function to images opened in \code{\link{digitizeRadii}} is is important that the images were created with the EXACT same magnification, are saved with the EXACT same dimensions (and aspect ratio), and the EXACT same value for \code{windowSize=} is used.
}
\examples{
## None yet
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
