% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_ps_table.R
\name{trim_ps_table}
\alias{trim_ps_table}
\title{Trim planetary systems table}
\usage{
trim_ps_table(data)
}
\arguments{
\item{data}{A data frame with planetary systems data.}
}
\value{
A data frame containing:
\itemize{
\item \code{objectid} - Object ID
\item \code{pl_name} – Planet name
\item \code{hostname} – Host star name
\item \code{sy_dist} – Distance to the system (parsecs)
\item \code{pl_rade} – Planetary radius (Earth radii)
\item \code{pl_bmasse} – Planetary mass (Earth masses)
\item \code{pl_orbper} – Orbital period (days)
\item \code{pl_orbsmax} – Semi-major axis (AU)
\item \code{pl_orbeccen} – Orbital eccentricity
\item \code{pl_insol} – Incident stellar flux (Earth units)
\item \code{st_teff} – Stellar effective temperature (K)
\item \code{st_rad} – Stellar radius (Solar radii)
\item \code{st_mass} – Stellar mass (Solar masses)
\item \code{st_lum} – Stellar luminosity (log10 L/Lsun)
\item \code{pl_eqt} – Planetary equilibrium temperature (K)
\item \code{pl_dens} – Planetary density
\item \code{discoverymethod} – Discovery method
\item \code{disc_year} – Year of discovery
\item \code{sy_snum} – Number of stars in system
\item \code{sy_pnum} – Number of planets in system
}
}
\description{
Trim planetary systems table
}
\details{
The function takes in a planetary systems data frame,
and trims it to include only 20 most important columns.
}
\examples{
trim_ps_table(closest_50_exoplanets)

}
