% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot_esi.R
\name{scatterplot_esi}
\alias{scatterplot_esi}
\title{Generate a Scatterplot of the Earth Similarity Index (ESI)}
\usage{
scatterplot_esi(data, plot_limits = c(0.1, 10))
}
\arguments{
\item{data}{A data frame containing exoplanet data. Must include the columns:
\itemize{
\item \code{pl_insol}: incident stellar flux (in Earth flux units),
\item \code{pl_rade}: planetary radius (in Earth radii),
\item \code{esi}: Earth Similarity Index (numeric).
}}

\item{plot_limits}{A numeric vector of length 2 specifying the lower and upper bounds.
Default is \code{c(0.1, 10)}.}
}
\value{
A ggplot2 object representing the scatterplot.
}
\description{
Creates a log-log scatterplot of planetary radius versus stellar flux,
colored by the Earth Similarity Index (ESI).
}
\details{
Dashed lines at (1,1) indicate Earth's reference values for stellar flux and radius.
}
\examples{
\donttest{
closest_50_exoplanets |>
  dplyr::mutate(esi = calculate_esi(radius = pl_rade, flux = pl_insol)) |>
  scatterplot_esi()
}
}
