% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_marginal_distributions.R
\name{import_marginal_distributions}
\alias{import_marginal_distributions}
\title{Import Marginal Distributions}
\usage{
import_marginal_distributions(
  folder_path = ".",
  binary_variables_file = "",
  categorical_variables_file = "",
  continuous_variables_file = "",
  continuous_quantiles_file = "",
  summary_file = "summary.csv"
)
}
\arguments{
\item{folder_path}{Where the marginal distribution files are located,
Default: '.' see details.}

\item{binary_variables_file}{filename for the binary_variables file,
Default: '' see details.}

\item{categorical_variables_file}{filename for the categorical variables file
, Default: '' see details.}

\item{continuous_variables_file}{filename for the continuous variables file,
Default: '' see details.}

\item{continuous_quantiles_file}{filename for the continuous quantiles file,
Default: '' see details.}

\item{summary_file}{filename for the summary file,
Default: 'summary.csv' see details.}
}
\value{
Returns an object of a RESIDE class
}
\description{
Import the marginal distribution as exported from a
Trusted Research Environment (TRE)
}
\details{
This function will import marginal distributions as generated
within a Trusted Research Environment (TRE) using the function
\code{\link{export_marginal_distributions}}.
The folder_path allows the path of the files
provided by the TRE to be imported,
this will default to the current working directory.
The file parameters will provide the default file names
if no filenames are specified.
}
\examples{
\dontrun{
  marginals <- import_marginal_distributions()
}
}
\seealso{
\code{\link{synthesise_data}}
}
