% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_checkboxes.R
\name{convert_checkbox_vals}
\alias{convert_checkbox_vals}
\title{Convert a new checkbox column's values}
\usage{
convert_checkbox_vals(
  metadata,
  .new_value,
  data_tbl,
  raw_or_label,
  multi_value_label,
  values_fill,
  multi_value_sep
)
}
\arguments{
\item{metadata}{A nested portion of the overall metadata tibble}

\item{.new_value}{The new column values made by \code{\link[=combine_checkboxes]{combine_checkboxes()}}}

\item{data_tbl}{The data tibble from the original supertibble}

\item{raw_or_label}{Either 'raw' or 'label' to specify whether to use raw coded
values or labels for the options. Default 'label'.}

\item{multi_value_label}{A string specifying the value to be used when multiple
checkbox fields are selected. Default "Multiple". If \code{NULL}, multiple
selections will be pasted together using \code{multi_value_sep} specification.}

\item{values_fill}{Value to use when no checkboxes are selected. Default \code{NA}.}

\item{multi_value_sep}{A string specifying the separator to use to paste
multiple selections together when \code{multi_value_label} is \code{NULL}. Default
\code{", "}.}
}
\description{
This function takes a single column of data and converts the values
based on the overall data tibble cross referenced with a nested section of the
metadata tibble.

\code{case_when} logic helps determine whether the value is a coalesced singular
value or a user-specified one via \code{multi_value_label} or \code{values_fill}.
If \code{multi_value_label} is \code{NULL}, multiple checkbox selections are pasted
together using \code{multi_value_sep} specification.
}
\details{
This function is used in conjunction with \code{pmap()}.
}
\keyword{internal}
