% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve-credential.R
\name{retrieve_credential}
\alias{retrieve_credential}
\alias{retrieve_credential_local}
\alias{retrieve_credential_mssql}
\alias{create_credential_local}
\title{Read a token and other credentials from a (non-REDCap)
database or file}
\usage{
retrieve_credential_local(
  path_credential,
  project_id,
  check_url            = TRUE,
  check_username       = FALSE,
  check_token_pattern  = TRUE,
  username             = NA_character_
)

retrieve_credential_mssql(
  project_id,
  instance,
  dsn,
  channel    = NULL
)

create_credential_local(
  path_credential
)
}
\arguments{
\item{path_credential}{The file path to the CSV containing the credentials.
Required.}

\item{project_id}{The ID assigned to the project withing REDCap.  This
allows the user to store tokens to multiple REDCap projects in one file.
Required}

\item{check_url}{A \code{logical} value indicates if the url in the credential
file should be checked to have approximately the correct form.  Defaults
to TRUE.
\code{\link[=retrieve_credential_local]{retrieve_credential_local()}}.}

\item{check_username}{A \code{logical} value indicates if the username in the
credential file should be checked against the username returned by R.
Defaults to FALSE.}

\item{check_token_pattern}{A \code{logical} value indicates if the token in the
credential file is a 32-character hexadecimal string.  Defaults to FALSE.}

\item{username}{A character value used to retrieve a credential.
See the Notes below. Optional.}

\item{instance}{The casual name associated with the REDCap instance on
campus.  This allows one credential system to accommodate multiple
instances on campus.  Required}

\item{dsn}{A \href{https://en.wikipedia.org/wiki/Data_source_name}{DSN} on the
local machine that points to the desired MSSQL database. Required.}

\item{channel}{An \emph{optional} connection handle as returned by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}.  See Details below. Optional.}
}
\value{
A list of the following elements are returned from
\code{retrieve_credential_local()} and \code{retrieve_credential_mssql()}:
\itemize{
\item \code{redcap_uri}: The URI of the REDCap Server.
\item \code{username}: Username.
\item \code{project_id}: The ID assigned to the project within REDCap.
\item \code{token}: The token to pass to the REDCap server
\item \code{comment}: An optional string that is ignored by REDCapR
but can be helpful for humans.
}
}
\description{
These functions are not essential to calling the REDCap API,
but instead are functions that help manage tokens securely.
}
\details{
If the database elements are created with the script provided in package's
'Security Database' vignette, the default values will work.

The \code{create_credential_local()} function copies a
\href{https://github.com/OuhscBbmc/REDCapR/blob/master/inst/misc/skeleton.credentials}{static file}
to the location specified in the \code{path_credential} argument.
Each record represents one accessible project per user.
Follow these steps to adapt to your desired REDCap project(s):
\enumerate{
\item Modify the credential file for the REDCap API with a text editor
like \href{https://notepad-plus-plus.org/}{Notepad++},
Visual Studio Code, or
\href{https://www.nano-editor.org/}{nano}.
Replace existing records with the information from your projects.
Delete the remaining example records.
\item Make sure that the file (with the sensitive password-like) tokens
is stored securely!
\item Contact your REDCap admin to request the URI & token and
discuss institutional policies.
\item Ask your institution's IT security team for their recommendation
\item For more info, see https://ouhscbbmc.github.io/REDCapR/articles/workflow-read.html
and https://ouhscbbmc.github.io/REDCapR/reference/retrieve_credential.html
\item Double-check the file is secured and not accessible by other users.
}
}
\note{
\emph{Storing credentials on a server is preferred}

Although we strongly encourage storing all the tokens on a central server
(\emph{e.g.}, see the \code{retrieve_credential_mssql()} function and the
"SecurityDatabase" vignette), there are times when this approach is not
feasible and the token must be stored locally.  Please contact us
if your institution is using something other than SQL Server, and
would like help adapting this approach to your infrastructure.

\emph{Storing credentials locally}

When storing credentials locally, typically the credential file
should be dedicated to just one user. Occasionally it makes sense to store
tokens for multiple users --usually it's for the purpose of testing.

The \code{username} field is connected only in the local credential file.
It does not need to be the same as the official username in REDCap.
}
\examples{
\dontrun{
# ---- Local File Example ----------------------------
path <- system.file("misc/dev-2.credentials", package = "REDCapR")
(p1  <- REDCapR::retrieve_credential_local(path, 33L))
(p2  <- REDCapR::retrieve_credential_local(path, 34L))


# Create a skeleton of the local credential file to modify
path_demo <- base::tempfile(pattern = "temp", fileext = ".credentials")

create_credential_local(path_demo)

base::unlink(path_demo) # This is just a demo; don't delete the real file!
}

}
\author{
Will Beasley
}
