% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climacell_core.R
\name{climacell_core}
\alias{climacell_core}
\title{Climacell Core Layer Data}
\usage{
climacell_core(
  api_key,
  lat,
  long,
  timestep,
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{api_key}{character string representing the private API key. Provided by user or loaded automatically from environment variable (environment variable must be called "CLIMACELL_API").}

\item{lat}{a numeric value (or a string that can be coerced to numeric) representing the latitude of the location.}

\item{long}{a numeric value (or a string that can be coerced to numeric) representing the longitude of the location.}

\item{timestep}{a 'step' value for the time. Choose one of the following valid values: c('1d', '1h', '30m','15m','5m','1m','current').}

\item{start_time}{the start time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. It is recommended that the \code{lubridate::now()} function or \code{Sys.time()} be used to define the start_time. For this function, the start_time cannot be less than 6 hours from the current time.}

\item{end_time}{the end time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. OPTIONAL if timestep is 'current' or if the user desires to get the maximum results possible (depends on the timestep chosen).}
}
\value{
a tibble
}
\description{
\code{climacell_core} returns a tibble that contains all of the Core Layer data from the Climacell version 4 API using the Timelines interface. The intent of this function is to retrieve all of the Core Layer data in a single API call. This is especially handy when using the free API as it limits the usage of the API based on hourly rate and daily usage.
}
\examples{
\dontrun{
climacell_core(
  api_key = Sys.getenv('CLIMACELL_API'),
  lat = 0,
  long = 0,
  timestep = '1d',
  start_time = lubridate::now(),
  end_time = lubridate::now + lubridate::days(5))
}

}
