% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCGLS-functions.R
\name{nc_open_CGLS}
\alias{nc_open_CGLS}
\title{Open netcdf CGLS data}
\usage{
nc_open_CGLS(date, product, resolution, version)
}
\arguments{
\item{date}{Date of interest, for example for 13 june 2019: 2019-06-13}

\item{product}{Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...}

\item{resolution}{1km, 300m or 100m}

\item{version}{Version number: v1, v2, v3,...}
}
\value{
CGLS data Opens single netcdf file in environment
}
\description{
Opens single orginal data files/layers of Copernicus Global as netCDF filesLand Service as netCDF files without adjusting coordinates. Coordinate adjustment is necessary as R uses upper left corner as pixel reference and Copernicus uses pixel centre. Also see: https://land.copernicus.eu/global/products/.
}
\details{
Adjusting coordinates is a necessary step to use the data because Copernicus nc files have lat/long belonging to the centre of the pixel, and R uses upper/left corner. This function opens the data without any corrections.
}
\note{
Coordinates are shifted and need to be adjusted, for example by:
if(resolution == "300m"){
lon <- lon - (1/336)/2
lat <- lat + (1/336)/2
}
if(resolution == "1km"){
lon <- lon - (1/112)/2
lat <- lat + (1/112)/2
}
}
\examples{
\dontrun{
library(ncdf4)
DATE       <- "2019-06-13" #Date of interest, for example for 13 june 2019: 2019-06-13
PROD    <- "fapar" #Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...
RES  <- "1km" #1km, 300m or 100m
V    <- "v1" #Version number: v1, v2, v3, ...

nc      <- nc_open_CGLS   (date=DATE, product=PROD, resolution=RES, version=V)
}
}
