% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dataset.R
\name{dataset}
\alias{dataset}
\title{dataset object constructor.}
\usage{
dataset(
  X,
  Y,
  data.dir = getwd(),
  data.fname = "CalibrationData.txt",
  fname = "Config_Data.txt",
  Xu = NULL,
  Xb = NULL,
  Xb.indx = NULL,
  Yu = NULL,
  Yb = NULL,
  Yb.indx = NULL,
  VAR.indx = NULL
)
}
\arguments{
\item{X}{data frame, observed input variables.}

\item{Y}{data frame, observed output variables (same number of rows as X).}

\item{data.dir}{Character, directory where a copy of the dataset will be
written if required. Default is the current working directory, but you
may prefer to use the BaM workspace.}

\item{data.fname}{Character, data file name.}

\item{fname}{Character, configuration file name.}

\item{Xu}{data frame, random uncertainty in X, expressed as a standard deviation.
Same dimension as X.}

\item{Xb}{data frame, systematic uncertainty in X, expressed as a standard deviation.
Same dimension as X.}

\item{Xb.indx}{data frame, index of systematic errors in X.
Same dimension as X.}

\item{Yu}{data frame, random uncertainty in Y, expressed as a standard deviation.
Same dimension as Y.}

\item{Yb}{data frame, systematic uncertainty in Y, expressed as a standard deviation.
Same dimension as Y.}

\item{Yb.indx}{data frame, index of systematic errors in Y.
Same dimension as Y.}

\item{VAR.indx}{data frame, indices used for defining how VAR parameters vary.}
}
\value{
An object of class 'dataset'.
}
\description{
Creates a new instance of a 'dataset' object
}
\examples{
X=data.frame(input1=rnorm(100),input2=rnorm(100))
Y=data.frame(output=X$input1+0.8*X$input2+0.1*rnorm(100))
workspace=tempdir()
d <- dataset(X=X,Y=Y,data.dir=workspace)
}
