##' Access Data from the Reserve Bank of New Zealand Website
##'
##' Provides a convenient way of accessing data published by the Reserve Bank
##' of New Zealand (RBNZ) on their website,
##' <https://www.rbnz.govt.nz/statistics>. A range of financial and economic
##' data is provided in spreadsheet format including exchange and interest
##' rates, commercial lending statistics, Reserve Bank market operations,
##' financial institution statistics, household financial data, New Zealand
##' debt security information, and economic indicators. This package provides
##' a method to download those spreadsheets and read them directly into R.
##'
##' @details The copyright notice for this data can be found at
##' \url{https://www.rbnz.govt.nz/about-our-site/terms-of-use}.
##'
##' @author Jasper Watson
##'
##' @import httr
##' @import rvest
##' @import xml2
##' @importFrom utils download.file
##'
##' @name RBNZ
##'
##
"_PACKAGE"
